/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.saml;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.saml.Saml2SettingsProvider;
import com.floragunn.searchguard.enterprise.auth.saml.SamlHTTPMetadataResolver;
import com.floragunn.searchguard.enterprise.auth.saml.SamlNameIdFormat;
import com.floragunn.searchguard.enterprise.auth.saml.StaticMetadataResolver;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.ValidationError;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.saml.config.impl.SAMLConfigurationInitializer;
import org.opensaml.saml.config.impl.XMLObjectProviderInitializer;
import org.opensaml.saml.metadata.resolver.MetadataResolver;

public class SamlAuthenticator
implements ApiAuthenticationFrontend,
AutoCloseable {
    private static final String SSO_CONTEXT_PREFIX = "saml_request_id:";
    protected static final Logger log = LogManager.getLogger(SamlAuthenticator.class);
    private static boolean openSamlInitialized = false;
    private URI idpMetadataUrl;
    private String idpMetadataXml;
    private String spSignatureAlgorithm;
    private Boolean useForceAuthn;
    private PrivateKey spSignaturePrivateKey;
    private Saml2SettingsProvider saml2SettingsProvider;
    private MetadataResolver metadataResolver;
    private boolean checkIssuer;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "saml", SamlAuthenticator.class).initialized().requiresEnterpriseLicense();
    public static TypedComponent.Info<ApiAuthenticationFrontend> INFO = new TypedComponent.Info<ApiAuthenticationFrontend>(){

        public Class<ApiAuthenticationFrontend> getType() {
            return ApiAuthenticationFrontend.class;
        }

        public String getName() {
            return "saml";
        }

        public TypedComponent.Factory<ApiAuthenticationFrontend> getFactory() {
            return SamlAuthenticator::new;
        }
    };

    public SamlAuthenticator(Map<String, Object> config, ConfigurationRepository.Context context) throws ConfigValidationException {
        Object metadataResolver;
        SamlAuthenticator.ensureOpenSamlInitialization();
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors, (Parser.Context)context);
        this.idpMetadataUrl = vNode.get("idp.metadata_url").asURI();
        this.idpMetadataXml = vNode.get("idp.metadata_xml").asString();
        this.spSignatureAlgorithm = vNode.get("sp.signature_algorithm").withDefault("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256").asString();
        String spSignaturePrivateKeyPassword = vNode.get("sp.signature_private_key_password").asString();
        this.spSignaturePrivateKey = (PrivateKey)vNode.get("sp.signature_private_key").byString(pem -> TLSConfig.toPrivateKey((String)pem, (String)spSignaturePrivateKeyPassword));
        this.useForceAuthn = vNode.get("sp.forceAuthn").asBoolean();
        this.checkIssuer = vNode.get("check_issuer").withDefault(true).asBoolean();
        String idpEntityId = vNode.get("idp.entity_id").required().asString();
        String spEntityId = vNode.get("sp.entity_id").asString();
        if (this.idpMetadataUrl == null && this.idpMetadataXml == null) {
            validationErrors.add(new com.floragunn.codova.validation.errors.ValidationError("idp.metadata_url", "idp.metadata_url and idp.metadata_xml are unconfigured"));
        }
        TLSConfig tlsConfig = (TLSConfig)vNode.get("idp.tls").by(TLSConfig::parse);
        if (!context.isExternalResourceCreationEnabled()) {
            this.metadataResolver = null;
        } else if (this.idpMetadataUrl != null) {
            try {
                metadataResolver = (SamlHTTPMetadataResolver)((Object)PrivilegedCode.execute(() -> new SamlHTTPMetadataResolver(this.idpMetadataUrl, tlsConfig), ResolverException.class));
                long refreshDelayMillis = vNode.get("idp.min_refresh_delay").withDefault((Number)60000L).asLong();
                metadataResolver.setMinRefreshDelay(SamlAuthenticator.millisToDuration(refreshDelayMillis));
                long maxRefreshDurationMillis = vNode.get("idp.max_refresh_delay").withDefault((Number)14400000L).asLong();
                metadataResolver.setMaxRefreshDelay(SamlAuthenticator.millisToDuration(maxRefreshDurationMillis));
                metadataResolver.setRefreshDelayFactor(vNode.get("idp.refresh_delay_factor").withDefault((Number)Float.valueOf(0.75f)).asFloat());
                ((SamlHTTPMetadataResolver)((Object)metadataResolver)).initializePrivileged();
                this.metadataResolver = metadataResolver;
            }
            catch (ComponentInitializationException | ResolverException e) {
                log.warn("Error while initializing " + this, e);
                validationErrors.add(new com.floragunn.codova.validation.errors.ValidationError("idp.metadata_url", e.getMessage()).cause(e));
            }
        } else if (this.idpMetadataXml != null) {
            try {
                metadataResolver = (StaticMetadataResolver)((Object)PrivilegedCode.execute(() -> new StaticMetadataResolver(this.idpMetadataXml.trim()), ConfigValidationException.class));
                ((StaticMetadataResolver)((Object)metadataResolver)).initializePrivileged();
                this.metadataResolver = metadataResolver;
            }
            catch (ConfigValidationException e) {
                log.warn("Error while initializing " + this, (Throwable)e);
                validationErrors.add("idp.metadata_xml", e);
            }
            catch (ComponentInitializationException e) {
                log.warn("Error while initializing " + this, (Throwable)e);
                validationErrors.add(new com.floragunn.codova.validation.errors.ValidationError("idp.metadata_xml", e.getMessage()).cause((Throwable)e));
            }
        }
        vNode.used(new String[]{"validator", "idp.min_refresh_delay", "idp.max_refresh_delay", "idp.refresh_delay_factor"});
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        this.saml2SettingsProvider = new Saml2SettingsProvider(idpEntityId, spEntityId, Settings.builder().loadFromMap((Map)vNode.getDocumentNode().toMap()).build().getAsSettings("validator"), this.metadataResolver);
        try {
            this.saml2SettingsProvider.get(URI.create("https://kibana.test"));
        }
        catch (Exception e) {
            log.debug("Exception while initializing Saml2SettingsProvider. Possibly, the IdP is unreachable right now. This is recoverable by a meta data refresh.", (Throwable)e);
        }
    }

    private static Duration millisToDuration(long refreshDelayMillis) {
        return Duration.of(refreshDelayMillis, ChronoUnit.MILLIS);
    }

    public ActivatedFrontendConfig.AuthMethod activateFrontendConfig(ActivatedFrontendConfig.AuthMethod frontendConfig, GetActivatedFrontendConfigAction.Request request) throws AuthenticatorUnavailableException {
        try {
            String samlRequest;
            if (request.getFrontendBaseUrl() == null) {
                throw new AuthenticatorUnavailableException("Configuration error", "frontend_base_url is required for SAML authentication").details("request", request.toBasicObject(), new Object[0]);
            }
            URI frontendBaseUrl = new URI(request.getFrontendBaseUrl());
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached(frontendBaseUrl);
            AuthnRequest authnRequest = this.buildAuthnRequest(saml2Settings);
            try {
                samlRequest = authnRequest.getEncodedAuthnRequest(Boolean.valueOf(true));
            }
            catch (IOException e) {
                throw new AuthenticatorUnavailableException("Internal error while creating SAML request", (Throwable)e);
            }
            String ssoLocation = this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SSO, saml2Settings, samlRequest, request.getNextURL());
            String ssoContext = SSO_CONTEXT_PREFIX + authnRequest.getId();
            return frontendConfig.ssoLocation(ssoLocation).ssoContext(ssoContext);
        }
        catch (URISyntaxException e) {
            log.error("Error while activating SAML authenticator", (Throwable)e);
            throw new AuthenticatorUnavailableException("frontend_base_url is not a valid URL", (Throwable)e).details("request", request.toBasicObject(), new Object[0]);
        }
    }

    public AuthCredentials extractCredentials(Map<String, Object> request) throws CredentialsException, ConfigValidationException, AuthenticatorUnavailableException {
        String acsEndpoint;
        String samlRequestId;
        URI frontendBaseUrl;
        HashMap<String, Object> debugDetails = new HashMap<String, Object>();
        if (!request.containsKey("saml_response")) {
            throw new ConfigValidationException((com.floragunn.codova.validation.errors.ValidationError)new MissingAttribute("saml_response"));
        }
        if (!request.containsKey("frontend_base_url")) {
            throw new ConfigValidationException((com.floragunn.codova.validation.errors.ValidationError)new MissingAttribute("frontend_base_url"));
        }
        try {
            frontendBaseUrl = new URI(String.valueOf(request.get("frontend_base_url")));
        }
        catch (URISyntaxException e) {
            throw new ConfigValidationException((com.floragunn.codova.validation.errors.ValidationError)new InvalidAttributeValue("frontend_base_url", request.get("frontend_base_url"), (Object)"A URL"));
        }
        String samlResponseBase64 = String.valueOf(request.get("saml_response"));
        String ssoContext = request.containsKey("sso_context") ? String.valueOf(request.get("sso_context")) : null;
        debugDetails.put("saml_response", samlResponseBase64);
        debugDetails.put("sso_context", ssoContext);
        Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached(frontendBaseUrl);
        if (ssoContext != null) {
            log.debug("Detected IdP initiated SSO; ssoContext: " + ssoContext);
            if (!ssoContext.startsWith(SSO_CONTEXT_PREFIX)) {
                throw new ConfigValidationException((com.floragunn.codova.validation.errors.ValidationError)new InvalidAttributeValue("saml_response", (Object)ssoContext, (Object)"Must start with saml_request_id:"));
            }
            samlRequestId = ssoContext.substring(SSO_CONTEXT_PREFIX.length());
            acsEndpoint = saml2Settings.getSpAssertionConsumerServiceUrl().toString();
        } else {
            log.debug("Detected IdP initiated SSO");
            acsEndpoint = saml2Settings.getSpAssertionConsumerServiceUrl().toString() + "/idpinitiated";
            samlRequestId = null;
        }
        try {
            String nameIdFormat;
            String nameId;
            String sessionIndex;
            SamlResponse samlResponse = this.createSamlResponse(saml2Settings, acsEndpoint, samlResponseBase64, debugDetails);
            PrivilegedCode.execute(() -> {
                try {
                    debugDetails.put("saml_response_attributes", samlResponse.getAttributes());
                    debugDetails.put("saml_response_issuer", samlResponse.getResponseIssuer());
                    debugDetails.put("saml_response_assertion_issuer", samlResponse.getAssertionIssuer());
                    debugDetails.put("saml_response_audiences", samlResponse.getAudiences());
                    debugDetails.put("saml_response_name_id_data", samlResponse.getNameIdData());
                }
                catch (Exception e) {
                    log.warn("Got Exception while collecting debug details", (Throwable)e);
                }
            });
            if (this.checkIssuer) {
                this.ensureResponseFromConfiguredEntity(samlResponse, saml2Settings, debugDetails);
            }
            if (!((Boolean)PrivilegedCode.execute(() -> samlResponse.isValid(samlRequestId))).booleanValue()) {
                log.info("Error while validating SAML response " + samlRequestId, (Throwable)samlResponse.getValidationException());
                throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Invalid SAML response: " + samlResponse.getValidationException(), debugDetails));
            }
            try {
                sessionIndex = (String)PrivilegedCode.execute(() -> samlResponse.getSessionIndex(), XPathExpressionException.class);
                nameId = (String)PrivilegedCode.execute(() -> samlResponse.getNameId(), Exception.class);
                nameIdFormat = (String)PrivilegedCode.execute(() -> samlResponse.getNameIdFormat() != null ? SamlNameIdFormat.getByUri(samlResponse.getNameIdFormat()).getShortName() : null, Exception.class);
            }
            catch (Exception e) {
                throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Error while extracting meta data from SAML response: " + e.getMessage(), debugDetails), (Throwable)e);
            }
            return AuthCredentials.forUser((String)nameId).userMappingAttribute("saml_response", this.extractAttributes(samlResponse)).attribute("__auth_type", (Object)"saml").attribute("__saml_si", (Object)sessionIndex).attribute("__saml_nif", (Object)nameIdFormat).attribute("__saml_nid", (Object)nameId).attribute("__fe_base_url", (Object)frontendBaseUrl.toString()).complete().build();
        }
        catch (ValidationError e) {
            log.warn("Error while validating SAML response", (Throwable)e);
            throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Invalid SAML response: " + e.getMessage() + "; error_code: " + e.getErrorCode(), debugDetails), (Throwable)e);
        }
    }

    public String getLogoutUrl(User user) throws AuthenticatorUnavailableException {
        try {
            URI frontendBaseUrl;
            if (user == null) {
                return null;
            }
            if (user.getStructuredAttributes().get("__fe_base_url") == null) {
                return null;
            }
            try {
                frontendBaseUrl = new URI(String.valueOf(user.getStructuredAttributes().get("__fe_base_url")));
            }
            catch (URISyntaxException e) {
                log.error("Cannot parse __fe_base_url of " + user + ": " + user.getStructuredAttributes().get("__fe_base_url"), (Throwable)e);
                return null;
            }
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached(frontendBaseUrl);
            if (!this.isSingleLogoutAvailable(saml2Settings)) {
                return null;
            }
            String nameId = user.getStructuredAttributes().get("__saml_nid") != null ? user.getStructuredAttributes().get("__saml_nid").toString() : user.getName();
            String nameIdFormat = user.getStructuredAttributes().get("__saml_nif") != null ? user.getStructuredAttributes().get("__saml_nif").toString() : null;
            String sessionIndex = user.getStructuredAttributes().get("__saml_si") != null ? user.getStructuredAttributes().get("__saml_si").toString() : null;
            LogoutRequest logoutRequest = new LogoutRequest(saml2Settings, null, nameId, sessionIndex, nameIdFormat);
            return this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SLO, saml2Settings, logoutRequest.getEncodedLogoutRequest(Boolean.valueOf(true)), null);
        }
        catch (IOException e) {
            log.error("Error while building logout URL for " + this, (Throwable)e);
            return null;
        }
    }

    public String getType() {
        return "saml";
    }

    private SamlResponse createSamlResponse(Saml2Settings saml2Settings, String acsEndpoint, String samlResponseBase64, Map<String, Object> debugDetails) throws ValidationError {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> new SamlResponse(saml2Settings, acsEndpoint, samlResponseBase64));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof ValidationError) {
                throw (ValidationError)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private void ensureResponseFromConfiguredEntity(SamlResponse samlResponse, Saml2Settings saml2Settings, Map<String, Object> debugDetails) throws CredentialsException {
        try {
            String issuer = (String)PrivilegedCode.execute(() -> samlResponse.getResponseIssuer(), ValidationError.class, XPathExpressionException.class);
            if (issuer != null && !issuer.equals(saml2Settings.getIdpEntityId())) {
                if (log.isDebugEnabled()) {
                    log.debug("Response is not from " + saml2Settings.getIdpEntityId() + " but from " + issuer + "\nWill abort check. If there are other SAML auth frontends, these might be successfully authenticate using this response");
                }
                throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Expected issuer " + saml2Settings.getIdpEntityId(), debugDetails));
            }
        }
        catch (ValidationError | XPathExpressionException e) {
            log.error("Error while checking issuer in " + samlResponse, e);
            throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Error while checking issuer: " + e, debugDetails), e);
        }
    }

    private AuthnRequest buildAuthnRequest(Saml2Settings saml2Settings) {
        boolean forceAuthn = false;
        if (this.useForceAuthn != null) {
            forceAuthn = this.useForceAuthn;
        } else if (!this.isSingleLogoutAvailable(saml2Settings)) {
            forceAuthn = true;
        }
        return new AuthnRequest(saml2Settings, forceAuthn, false, true);
    }

    private URL getIdpUrl(IdpEndpointType endpointType, Saml2Settings saml2Settings) {
        if (endpointType == IdpEndpointType.SSO) {
            return saml2Settings.getIdpSingleSignOnServiceUrl();
        }
        return saml2Settings.getIdpSingleLogoutServiceUrl();
    }

    private boolean isSingleLogoutAvailable(Saml2Settings saml2Settings) {
        return saml2Settings.getIdpSingleLogoutServiceUrl() != null;
    }

    @Override
    public void close() {
        if (this.metadataResolver instanceof DestructableComponent) {
            ((DestructableComponent)this.metadataResolver).destroy();
        }
    }

    private Map<String, ?> extractAttributes(SamlResponse samlResponse) {
        try {
            return (Map)PrivilegedCode.execute(() -> samlResponse.getAttributes(), ValidationError.class, XPathExpressionException.class);
        }
        catch (ValidationError | XPathExpressionException e) {
            log.warn("Got exception while extracting attributes from " + samlResponse, e);
            return ImmutableMap.empty();
        }
    }

    static void ensureOpenSamlInitialization() {
        if (openSamlInitialized) {
            return;
        }
        try {
            PrivilegedCode.execute(() -> {
                Thread thread = Thread.currentThread();
                ClassLoader originalClassLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(InitializationService.class.getClassLoader());
                    InitializationService.initialize();
                    new XMLObjectProviderInitializer().init();
                    new SAMLConfigurationInitializer().init();
                    new org.opensaml.xmlsec.config.impl.XMLObjectProviderInitializer().init();
                }
                finally {
                    thread.setContextClassLoader(originalClassLoader);
                }
                openSamlInitialized = true;
            }, InitializationException.class);
        }
        catch (InitializationException e) {
            throw new RuntimeException("Error while initializing SAML", e);
        }
    }

    private String getSamlRequestRedirectBindingLocation(IdpEndpointType idpEndpointType, Saml2Settings saml2Settings, String samlRequest, String relayState) throws AuthenticatorUnavailableException {
        URL idpUrl = this.getIdpUrl(idpEndpointType, saml2Settings);
        if (Strings.isNullOrEmpty((String)idpUrl.getQuery())) {
            return this.getIdpUrl(idpEndpointType, saml2Settings) + "?" + this.getSamlRequestQueryString(samlRequest, relayState);
        }
        return this.getIdpUrl(idpEndpointType, saml2Settings) + "&" + this.getSamlRequestQueryString(samlRequest, relayState);
    }

    private String getSamlRequestQueryString(String samlRequest, String relayState) throws AuthenticatorUnavailableException {
        String queryString = "SAMLRequest=" + Util.urlEncoder((String)samlRequest);
        if (relayState != null) {
            queryString = queryString + "&RelayState=" + Util.urlEncoder((String)relayState);
        }
        if (this.spSignaturePrivateKey == null) {
            return queryString;
        }
        queryString = queryString + "&SigAlg=" + Util.urlEncoder((String)this.spSignatureAlgorithm);
        String signature = this.getSamlRequestQueryStringSignature(queryString);
        queryString = queryString + "&Signature=" + Util.urlEncoder((String)signature);
        return queryString;
    }

    private String getSamlRequestQueryStringSignature(String samlRequestQueryString) throws AuthenticatorUnavailableException {
        try {
            return Util.base64encoder((byte[])Util.sign((String)samlRequestQueryString, (PrivateKey)this.spSignaturePrivateKey, (String)this.spSignatureAlgorithm));
        }
        catch (Exception e) {
            throw new AuthenticatorUnavailableException("Error while signing SAML request", (Throwable)e);
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private static enum IdpEndpointType {
        SSO,
        SLO;

    }
}

